/*
   XXX does not use built-in detection function! XXX

alert ip $EXTERNAL_NET any -> $HOME_NET any (msg:"BAD-TRAFFIC Microsoft Windows ISATAP-addressed IPv6 traffic spoofing attempt"; reference:cve,2010-0812; reference:url,technet.microsoft.com/en-us/security/bulletin/MS10-029; classtype:misc-attack; sid:16533; rev:1;)
*/
/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG 
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

/* declare detection functions */
int rule16533eval(void *p);

/* declare rule data structures */

/* references for sid 16533 */
/* reference: cve "2010-0812"; */
static RuleReference rule16533ref1 = 
{
    "cve", /* type */
    "2010-0812" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS10-029"; */
static RuleReference rule16533ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS10-029" /* value */
};

static RuleReference *rule16533refs[] =
{
    &rule16533ref1,
    &rule16533ref2,
    NULL
};
/* metadata for sid 16533 */
/* metadata:; */


static RuleMetaData *rule16533metadata[] =
{
    NULL
};

RuleOption *rule16533options[] =
{
    NULL
};

Rule rule16533 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_IP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       16533, /* sigid */
       6, /* revision */
       "misc-attack", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft Windows ISATAP-addressed IPv6 traffic spoofing attempt",     /* message */
       rule16533refs /* ptr to references */
       ,rule16533metadata
   },
   rule16533options, /* ptr to rule options */
   &rule16533eval, /* DO NOT use the built in detection function */
   0 /* am I initialized yet? */
};

/* detection functions */
int rule16533eval(void *p) {

/* This is a really old piece of detection.  A change in the packet structure in 2.9.8.0 makes the
   below segfault when you run it with the wrong engine, or just not even compile if you use the proper
   headers because sp->ip6h->ip_src and sp->ip4h->ip_src no longer exist.  I need to fix this code once
   I find the correct way to access those functions using the new engine (supposedly there's an API call
   that I should have been using), but for now we just need this to compile.  And the vuln is so old,
   tbh the urgency to fix this just really isn't there.
*/ 
#ifdef MISSING_COMB_ADDRS
    SFSnortPacket *sp = (SFSnortPacket *) p;

    uint32_t isatap_interface_id; 

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;

    if(sp->ip6h == NULL || sp->ip4h == NULL)
        return RULE_NOMATCH;

    if(sp->ip4h->ip_proto == 41) // if ipv6 is ipv4's payload
    {
        DEBUG_SO(printf("interface ID %08x\n", ntohl(sp->ip6h->ip_src.ip.u6_addr32[2]));) 
        isatap_interface_id = ntohl(sp->ip6h->ip_src.ip.u6_addr32[2]) & 0xFCFFFFFF; // to clear 'ug' bits
        
        if (isatap_interface_id == 0x00005EFE) // we don't need to worry about 'ug' bits since they are cleared 
        {
            DEBUG_SO(printf("ipv4 %08x\n", sp->ip4h->ip_src.ip.u6_addr32[0]);)
            DEBUG_SO(printf("ipv6 %08x\n", sp->ip6h->ip_src.ip.u6_addr32[3]);)

            if (sp->ip4h->ip_src.ip.u6_addr32[0] != sp->ip6h->ip_src.ip.u6_addr32[3])
                return RULE_MATCH;
        }
    }
#endif
    
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule16533,
    NULL
};
*/
